function [coeff] = coeffcheck(coeff)
%COEFFCHECK This function checks the orientation of the plane that was fit
%to the endplates to ensure it initially is pointing in the correct
%direction
%   The original normal vector can be flipped upside down, depending on the
%   planes orientation in space. This function checks if it is flipped and
%   fixes it
for i=1:length(coeff)
    if coeff{i}(1,1)<0
        coeff{i}(1,:)=-1*coeff{i}(1,:);
    end
    if coeff{i}(2,2)<0
        coeff{i}(2,:)=-1*coeff{i}(2,:);
    end
    if coeff{i}(3,3)<0
        coeff{i}(3,:)=-1*coeff{i}(3,:);
    end
end

end

