function [ file2, file_ax ] = filenamer(files,i)
%FILENAMER This function will read in the sagittal ROIs and use them to
%create the filename for the posterior file
%   'files' is the list of all the files in the target sagittal folder
%   'i' is the filenumber in the list we are interested in
%    'files2' is the input file for the sagittal ROIs  
%    'file_ax' is the input file for the posterior ROIs

%The first part locates the beginning and back of the file number we are 
%interested in 
f_ind1=strfind(files(i).name,'LS');
f_ind2=strfind(files(i).name,'.csv');
filenum1=files(i).name(f_ind1+2:f_ind1+4);
filenum2=files(i).name(f_ind2-1);
file2 = files(i).name;
file_ax=['LS' filenum1 '_Axi_P' filenum2 '.csv'];
end