function [x_coord,y_coord,z_coord, x_coord_ped, y_coord_ped, z_coord_ped]=readROI2(file)
%readROI2 This function reads all the x, y, and z coordinates in from..
%the sagittal and posterior ROIs.  
%
%For the variable 'points' the ROI positions are described:
%       What ROI # it is (1. anterior superior endplate
%       2. posterior superior endplate 3. posterior inferior endplate
%       4. anterior inferior endplate 5. Pedicle Base)
%NOTE: _ped outputs are not being used in the script after 20131231

import = importdata(file); % NOTE: Slice number is reversed when exported to csv file format in Osirix
import.textdata(1)=import.textdata(2,1);
slice = import.textdata(:,1);%Which image number is it from (slice number)
level = import.textdata(:,8);%Which I.V. level is it from
level(1) = [];%delete extra input

%This for loop goes through each slice and each level and sorts what point
%location this is (Described in point) and whether or not it is a lumbar or
%sacral vertebrae.  There will be used later for sorting through thr ROI
%numbers
for i = 1:length(level)
    tmp(i) = level{i}(2);%Vertebra Level i.e. 1, 2, 3
    tmp2(i+1) = str2num(cell2mat(slice(i+1)));%image number
    point(i) = level{i}(4);%What ROI # it is (1. anterior superior endplate
    %2. posterior superior endplate 3. posterior inferior endplate
    %4. anterior inferior endplate 5. Pedicle Base
    lumbar(i) = level{i}(1) == 'L';%Is it a Lumbar (1) or Sacral (0) bone
end
slice = tmp2;
slice(1) = [];

level = tmp';
point = point';
tmp = str2num(point);

if min(slice) == 0, slice = slice+1; end %ensures you dont have any slice "0"

version_test = sum(import.data == 1);
offset = find(version_test == size(import.data,1));%these two lines of code
%help you to find the column before where you begin to find your pixel
%locations in space
%Initialize data for speed
x_coord_ped=0;
y_coord_ped=0;
z_coord_ped=0;

%This for loop will sort out the x, y and z coordinates, split up into
%different variables based on each coordinate location.  The x,y,z
%coordinate from one ROI will be indexed in the same location across each
%variable.  Each row defines a level, each column describes a location on
%the vertebrae as defined above at point), each 3rd "column" represents a
%different slice.
for j = 1:length(slice)
    if lumbar(j) %if it is a lumbar vertebra
        if str2num(point(j)) ~= 5 %If it is not a lumbar point
            x_coord(str2num(level(j)), str2num(point(j)),slice(j)) = import.data(j,offset+4);%*0.9375; % AP
            z_coord(str2num(level(j)), str2num(point(j)),slice(j)) = import.data(j,offset+5);%*0.9375; % SI
            y_coord(str2num(level(j)), str2num(point(j)),slice(j)) = slice(j);%*4; % 4mm Thick
        else %else it is a lumbar point
            x_coord_ped(str2num(level(j)), str2num(point(j)),slice(j)) = import.data(j,offset+4);
            z_coord_ped(str2num(level(j)), str2num(point(j)),slice(j)) = import.data(j,offset+5);
            y_coord_ped(str2num(level(j)), str2num(point(j)),slice(j)) = slice(j);
        end
    else %it is a sacral vertebra
        if str2num(point(j)) ~= 5 %If it is not a lumbar point
            x_coord(6, str2num(point(j)),slice(j)) = import.data(j,offset+4);%*0.9375; % AP
            z_coord(6, str2num(point(j)),slice(j)) = import.data(j,offset+5);%*0.9375; % SI
            y_coord(6, str2num(point(j)),slice(j)) = slice(j);%*4; % 4mm Thick
        else %else it is a lumbar point
            x_coord_ped(6, str2num(point(j)),slice(j)) = import.data(j,offset+4);
            z_coord_ped(6, str2num(point(j)),slice(j)) = import.data(j,offset+5);
            y_coord_ped(6, str2num(point(j)),slice(j)) = slice(j);
        end
    end
end