function [vecout]=readROI2postvec(file,ipres,thk)
%readROI2postvec This ROI tool is developed for reading in axial images
%It is nearly identical to readROI2 except it was changed to create vecout
%VECOUT is a 6x2 matrix that has a vector that describes the z axis. Each 
%row describes a level, each column describes the different components of  
%the vector
%
%This function reads all the x, y, and z coordinates in from..
%the sagittal and posterior ROIs.  
%
%For the variable 'points' the ROI positions are described:
%       What ROI # it is (1. anterior superior endplate
%       2. posterior superior endplate 3. posterior inferior endplate
%       4. anterior inferior endplate 5. Pedicle Base)
%NOTE: _ped outputs are not being used in the script after 20131231import = importdata(file); % NOTE: Slice number is reversed when exported to csv file format in Osirix

import = importdata(file); 
import.textdata(1)=import.textdata(2,1);
slice = import.textdata(:,1);
level = import.textdata(:,8);
level(1) = [];
for i = 1:length(level)
    tmp(i) = level{i}(2);%Vertebra Level i.e. 1, 2, 3
    tmp2(i+1) = str2num(cell2mat(slice(i+1)));%image number
    point(i) = level{i}(4);%What ROI # it is (1. anterior superior endplate
    %2. posterior superior endplate 3. posterior inferior endplate
    %4. anterior inferior endplate 5. Pedicle Base
    lumbar(i) = level{i}(1) == 'L';%Is it a Lumbar (1) or Sacral (0) bone
end
slice = tmp2;
slice(1) = [];

level = tmp';
point = point';
tmp = str2num(point);

if min(slice) == 0, slice = slice+1; end %ensures you dont have any slice "0"

version_test = sum(import.data == 1);
offset = find(version_test == size(import.data,1));%these two lines of code
%help you to find the column before where you begin to find your pixel
%locations in space

for j = 1:length(slice)
    if lumbar(j)
        if point(j) == 'L'
            x_coordL(str2num(level(j)))= import.data(j,offset+4);
            y_coordL(str2num(level(j)))= import.data(j,offset+5);
            z_coordL(str2num(level(j)))= slice(j);
        elseif point(j) == 'R'
            x_coordR(str2num(level(j)))= import.data(j,offset+4);
            y_coordR(str2num(level(j)))= import.data(j,offset+5);
            z_coordR(str2num(level(j)))= slice(j);
        end
    else
        if point(j) == 'L'
            x_coordL(6)= import.data(j,offset+4);
            y_coordL(6)= import.data(j,offset+5);
            z_coordL(6)= slice(j);
        elseif point(j) == 'R'
            x_coordR(6)= import.data(j,offset+4);
            y_coordR(6)= import.data(j,offset+5);
            z_coordR(6)= slice(j);
        end
        
    end

end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%This is the main different part from the readROI2.  This part calculates
%the normalized output vector

%Here I calculate the vector that defines posterior elements
x_comp=(x_coordR-x_coordL)*thk;
y_comp=(y_coordR-y_coordL)*ipres;
z_comp=(z_coordR-z_coordL)*ipres;

vecmat=[y_comp; x_comp; z_comp]';
if sum(vecmat(1,:))==0
    vecmat(1,:)=[]; %For Validation study
end
vecmat(:,3)=0;
vecout=spdiags(sum(abs(vecmat),2),0,size(vecmat,1),size(vecmat,1))\vecmat; %Normalize