function [outmat] = rotatecoords(normal,postvec)
%ROTATECOORDS This function defines each endplates coordinate system. It 
%takes the vector normal to the plane that was fit to the endplate, and
%projects a vector parallel to like elemnts on the posterior elements
%(postvec) onto the plane. Then the third vector is defined as orthogonal
%to the other two vectors.
for i=1:size(postvec,1) %for each level
    a=postvec(i,:);
    b=normal{i}';
    tmp2=cross(b,cross(a,b)/norm(b))/norm(b);
    tmp1=cross(tmp2,b);
    outmat{i}=[tmp1;tmp2;b];
end

