function Rot = rotmat(angle1,angle2,angle3);
%calculates the rotation matrix in order XYZ in a right handed system
%the coordinate system is rotated, not the points!

Rx = [1 0 0 ; 0 cosd(angle1) -sind(angle1) ; 0 sind(angle1) cosd(angle1)]; 
Ry = [cosd(angle2) 0 sind(angle2) ; 0 1 0 ; -sind(angle2) 0 cosd(angle2)];
Rz = [cosd(angle3) -sind(angle3) 0 ; sind(angle3) cosd(angle3) 0 ; 0 0 1];
Rot = Ry*Rz*Rx;
% Rot = Rz*Ry*Rx; Original 08062013